/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import com.ibm.hsc.fsp.cmdhelpers.SrcEntry;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;

public class FspLparSrcEntry {
    public static final String METHOD_GET_CURRENT_SRC = "getCurrentSRC";
    public static final String METHOD_GET_SRC_FROM_SEQ_NUM = "getSrcFromSeqNum";
    public static final int LPAR_NO_SRC = 32774;
    private SrcEntry srcEntry = null;

    public FspLparSrcEntry handleCommands(String string, FSPCmdMgr fSPCmdMgr, Vector vector, String string2) throws PIHscServerException {
        int n = string2.indexOf("*");
        int n2 = 0;
        n2 = n != -1 ? Integer.parseInt(string2.substring(0, string2.indexOf("*"))) : Integer.parseInt(string2);
        if (METHOD_GET_CURRENT_SRC.equals(string)) {
            boolean bl = false;
            if (vector != null && vector.size() > 0) {
                CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
                bl = (Boolean)cIMProperty.getValue().getValue();
            }
            return this.getCurrentSRCAndSequenceNumber(fSPCmdMgr, new UnsignedInt16(n2), bl);
        }
        if (METHOD_GET_SRC_FROM_SEQ_NUM.equals(string)) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(0);
            UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMProperty.getValue().getValue();
            boolean bl = false;
            if (vector.size() > 1) {
                cIMProperty = (CIMProperty)vector.elementAt(2);
                bl = (Boolean)cIMProperty.getValue().getValue();
            }
            return this.getSRCFromSequenceNumber(fSPCmdMgr, new UnsignedInt16(n2), unsignedInt32, bl);
        }
        return null;
    }

    FspLparSrcEntry getCurrentSRCAndSequenceNumber(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, boolean bl) throws PIHscServerException {
        Hashtable hashtable = new Hashtable();
        try {
            hashtable = fSPCmdMgr.doPhypCommand("GET_PARTITION_CURR_SRC_AND_SEQUENCE_NUMBER", new String[]{unsignedInt16.toString()});
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            int n = pIHscCmdMgrException.getStatus();
            if (n != 0) {
                if (n == 32774) {
                    System.out.println("getCurrentSRC: PHYP return code 0x8006.");
                    throw new PIHscServerException("2527", null, pIHscCmdMgrException);
                }
                throw new PIHscServerException("2522", new String[]{METHOD_GET_CURRENT_SRC, Integer.toHexString(n)}, pIHscCmdMgrException);
            }
            throw new PIHscServerException("2522", new String[]{METHOD_GET_CURRENT_SRC, new String(" ")}, pIHscCmdMgrException);
        }
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)hashtable.get("SEQ_NUMBER");
        Object[] objectArray = (Object[])hashtable.get("LPAR_SRC_LIST");
        Hashtable hashtable2 = (Hashtable)objectArray[0];
        hashtable2.put("SEQ_NUMBER", unsignedInt32);
        hashtable2.put("parse_subsection", new Boolean(bl));
        this.srcEntry = new SrcEntry(hashtable2);
        return this;
    }

    FspLparSrcEntry getSRCFromSequenceNumber(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16, UnsignedInt32 unsignedInt32, boolean bl) throws PIHscServerException {
        Hashtable hashtable = new Hashtable();
        try {
            hashtable = fSPCmdMgr.doPhypCommand("GET_PARTITION_SRC_FROM_SEQUENCE_NUMBER", new String[]{unsignedInt16.toString(), unsignedInt32.toString()});
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            int n = pIHscCmdMgrException.getStatus();
            if (n != 0) {
                if (n == 32774) {
                    System.out.println("getSrcFromSeqNum: PHYP return code 0x8006.");
                    throw new PIHscServerException("2527", null, pIHscCmdMgrException);
                }
                throw new PIHscServerException("2522", new String[]{METHOD_GET_SRC_FROM_SEQ_NUM, Integer.toHexString(n)}, pIHscCmdMgrException);
            }
            throw new PIHscServerException("2522", new String[]{METHOD_GET_SRC_FROM_SEQ_NUM, new String(" ")}, pIHscCmdMgrException);
        }
        UnsignedInt32 unsignedInt322 = (UnsignedInt32)hashtable.get("SEQ_NUMBER");
        Object[] objectArray = (Object[])hashtable.get("LPAR_SRC_LIST");
        Hashtable hashtable2 = (Hashtable)objectArray[0];
        hashtable2.put("parse_subsection", new Boolean(bl));
        hashtable2.put("SEQ_NUMBER", unsignedInt322);
        this.srcEntry = new SrcEntry(hashtable2);
        return this;
    }

    public SrcEntry getSrcEntry() {
        return this.srcEntry;
    }

    public void setSrcEntry(SrcEntry srcEntry) {
        this.srcEntry = srcEntry;
    }
}

